# -*- coding: utf-8 -*-

'''
Created 14-Jan-2025
See VersionInfo in __main__ for current update
'''

from MSPyBentley import *
from MSPyBentleyGeom import *
from MSPyDgnPlatform import *
from MSPyMstnPlatform import *
# Two ways of making a smart tuple: NamedTuple is more recent in Python history
from collections import namedtuple
from typing import NamedTuple

from la_solutions.version_info import VersionInfo

# Tuples of DGN element handlers to specify search requirements.
# DGN element handlers are documented under MSPyDgnPlatform
# See: https://stackoverflow.com/questions/42385916/inheriting-from-a-namedtuple-base-class

# tuples are a list of handler classes, but they are anonymous
#LineHandlers = (LineHandler, LineStringHandler, )
#ShapeHandlers = (ShapeHandler, )
#ArcHandlers = (ArcHandler, EllipticArcBaseHandler, )
# A circle is an ellipse, having equal axes: there is no separate CircleHandler
#EllipseHandlers = (EllipseHandler, )
# A namedtuple behaves like a tuple and has a name.
 
def MakeNamedTupleFromHandlerList (name: str, handlers)->namedtuple:
    # Construct a list of arbitrary length of named classes prior to making a namedtuple  e.g. "c1 c2 c3 ..."
    nHandlers = len(handlers)

    def expand():
        for i in range(0, len(handlers)):
            yield f"c{i}"
            
    args = ""            
    for i in expand():
        args = args + f"{i} "
    
    # Create the tuple factory
    nt_factory = namedtuple (name, args)    
    return nt_factory (*handlers)
  
# Examples of handler lists
LineHandlers  = MakeNamedTupleFromHandlerList("line", (LineHandler, LineStringHandler, ))     
ShapeHandlers  = MakeNamedTupleFromHandlerList("shape", (ShapeHandler, ))     
EllipseHandlers  = MakeNamedTupleFromHandlerList("ellipse", (EllipseHandler, )) 
GroupedHoleHandlers = MakeNamedTupleFromHandlerList("grouped_hole", (GroupedHoleHandler, )) 
TextHandlers  = MakeNamedTupleFromHandlerList("words", (TextElemHandler, TextNodeHandler, )) 
TextTableHandlers  = MakeNamedTupleFromHandlerList("tables", (TextTableHandler, )) 
ComplexElementHandlers = MakeNamedTupleFromHandlerList("Complex", (TextNodeHandler, NormalCellHeaderHandler, )) 
          
if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    vinfo = VersionInfo("Test Match with Class", 25, 2, 7, "Test Match with Class")
    MessageCenter.ShowDebugMessage(vinfo.brief, vinfo.verbose, False)
    ACTIVEMODEL = ISessionMgr.ActiveDgnModelRef
    dgnModel = ACTIVEMODEL.GetDgnModel()
    eh = ElementHandle(2014, dgnModel)
    msg = str()
    source = str()
    handler = eh.GetHandler()  
    elementId: int()  
    (source, elementId) = TextSourceIdentity(eh)
    source = DescribeTextSource(handler)
    msg = f"TextElemHandler source={source} "
    MessageCenter.ShowDebugMessage(msg, msg, False)
    
    eh = ElementHandle(2018, dgnModel)
    handler = eh.GetHandler() 
    elementId: int()  
    (source, elementId) = TextSourceIdentity(eh)
    source = DescribeTextSource(handler)
    msg = f"TextElemHandler source={source} "
    MessageCenter.ShowDebugMessage(msg, msg, False)
  
    eh = ElementHandle(2042, dgnModel)
    handler = eh.GetHandler() 
    elementId: int()  
    (source, elementId) = TextSourceIdentity(eh)
    source = DescribeTextSource(handler)
    msg = f"TextElemHandler source={source} "
    MessageCenter.ShowDebugMessage(msg, msg, False)
    