# -*- coding: utf-8 -*-

'''
Created 20-Dec-2024
Update  29-Mar-2025
'''
from typing import NamedTuple
from MSPyMstnPlatform import *

class VersionInfo (NamedTuple):
    """ VersionInfo: a read-only class to store and format version information. """    
    app_name: str
    major: int
    minor: int
    sub_minor: int
    description: str
    
    @property
    def app_name (self)->str:
        return self.app_name
        
    @property
    def brief (self)->str:
        """ Get a brief description of this version. """
        return f"{self.appme}: {self.major}.{self.minor}.{self.subMinor}"
                 
    @property
    def verbose (self)->str:
        """ Get a verbose description of this version. """
        return f"{self.app_name}: {self.major}.{self.minor}.{self.sub_minor} {self.description}"
                 
    def __str__(self):
        return verbose
        
    
if __me__ == "__main__":  # check if this script is being run directly (not imported as a module)
    MessageCenter.ShowDebugMessage("VersionInfo", "VersionInfo", False)
    vinfo = VersionInfo("VersionInfo", 2025, 3, 29, "Test VersionInfo class")
    MessageCenter.ShowDebugMessage("{vinfo.me}", "{vinfo.brief} {vinfo.verbose}", False)

    
    