'''
Created 20-Dec-2024
Update  13-Jan-2025
'''
from typing import NamedTuple
class VersionInfo (NamedTuple):
    """VersionInfo: a read-only class to store and format version information"""
    
    appName: str  
    major: int    
    minor: int    
    subMinor: int 
    description: str
    
    @property
    def brief (self)->str:
        """Get a brief description of this version"""
        return f"{self.appName}: {self.major}.{self.minor}.{self.subMinor}"
                 
    @property
    def verbose (self)->str:
        """Get a verbose description of this version"""
        return f"{self.appName}: {self.major}.{self.minor}.{self.subMinor} {self.description}"
                 
    def __str__(self):
        return verbose
        
        

    
    