# -*- coding: utf-8 -*-

'''
Created 14-Jan-2025
See VersionInfo in __main__ for current update
'''

from MSPyBentley import *
from MSPyBentleyGeom import *
from MSPyDgnPlatform import *
from MSPyMstnPlatform import *

from la_solutions.version_info import VersionInfo

#   Where text is found
TEXT_SOURCE_PRIMITIVE = "text element"
TEXT_SOURCE_CELL      = "cell"
TEXT_SOURCE_NODE      = "text node"
TEXT_SOURCE_TABLE     = "text table"
TEXT_SOURCE_UNKNOWN   = "unknown"

def TextSourceIdentity (eh: ElementHandle)->(str, int):
    # A text element may be found stand-alone or embedded in a text node, cell or text table.
    # Some applications may find it useful to know the source of a text element.
    # This function returns a tuple containing the source description and its Element ID.
    elementId = eh.GetElementId()
    source = DescribeTextSource(eh.GetHandler())
    return (source, elementId)

def DescribeTextSource (handler: Handler)->str:
    # A text element may be found stand-alone or embedded in a text node, cell or text table.
    # Some applications may find it useful to know the source of a text element.
    match handler.__class__.__qualname__:
        case TextElemHandler.__qualname__:
            return TEXT_SOURCE_PRIMITIVE
        case TextNodeHandler.__qualname__:
            return TEXT_SOURCE_NODE
        case TextTableHandler.__qualname__:
            return TEXT_SOURCE_TABLE
        case NormalCellHeaderHandler.__qualname__:
            return TEXT_SOURCE_CELL  
        case _:
            return TEXT_SOURCE_UNKNOWN
          
if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    vinfo = VersionInfo("Test Match with Class", 25, 1, 19, "Test Match with Class")
    MessageCenter.ShowDebugMessage(vinfo.brief, vinfo.verbose, False)
    ACTIVEMODEL = ISessionMgr.ActiveDgnModelRef
    dgnModel = ACTIVEMODEL.GetDgnModel()
    eh = ElementHandle(2014, dgnModel)
    msg = str()
    source = str()
    handler = eh.GetHandler()  
    elementId: int()  
    (source, elementId) = TextSourceIdentity(eh)
    source = DescribeTextSource(handler)
    msg = f"TextElemHandler source={source} "
    MessageCenter.ShowDebugMessage(msg, msg, False)
    
    eh = ElementHandle(2018, dgnModel)
    handler = eh.GetHandler() 
    elementId: int()  
    (source, elementId) = TextSourceIdentity(eh)
    source = DescribeTextSource(handler)
    msg = f"TextElemHandler source={source} "
    MessageCenter.ShowDebugMessage(msg, msg, False)
  
    eh = ElementHandle(2042, dgnModel)
    handler = eh.GetHandler() 
    elementId: int()  
    (source, elementId) = TextSourceIdentity(eh)
    source = DescribeTextSource(handler)
    msg = f"TextElemHandler source={source} "
    MessageCenter.ShowDebugMessage(msg, msg, False)
    