# -*- coding: utf-8 -*-

'''
Created 26-Jan-2025
Updated 27-Jan-2025
Utility functions that operate on DGN elements.
'''

from MSPyBentley import *
from MSPyBentleyGeom import *
from MSPyDgnPlatform import *
from MSPyMstnPlatform import *

# See: https://bentleysystems.service-now.com/community?id=community_question&sys_id=3950e8461b6612147171ff7e034bcb58
# Used with ChildElemIter
EXPOSE_CHILDREN_COUNT = ExposeChildrenReason(100)
EXPOSE_CHILDREN_QUERY = ExposeChildrenReason(200)
EXPOSE_CHILDREN_EDIT  = ExposeChildrenReason(300)

ELEM_HANDLER_GET_DESCR_MAX_LENGTH =32      
def GetElementDescription (element, stringLength: int = ELEM_HANDLER_GET_DESCR_MAX_LENGTH)->str:
    '''
    Get the human-readable description of an element from an elementRef or ElementHandle.
    '''
    description = WString()
    if isinstance (element, ElementHandle):
        handler = element.GetHandler()
        if handler is None:
            MessageCenter.ShowErrorMessage(f"GetElementDescription() ElementHandle is None!", None, False)
        else:
            handler.GetDescription (element, description, stringLength)
        
    elif isinstance (element, PersistentElementRef):
        eh = ElementHandle (element, dgnModel)
        handler = eh.GetHandler()       
        handler.GetDescription (eh, description, stringLength)
        
    return str(description)

def GetElementById(elementId: int, dgnModel: DgnModel = ISessionMgr.ActiveDgnModelRef.GetDgnModel())->[bool, ElementHandle]:
    '''
    Get an element by its ID in the supplied DGN model.
    Returns: tuple (boolean: valid, Element Handle)
    '''
    eh = ElementHandle(elementId, dgnModel)  
    valid = eh.IsValid()
    if not valid:
        msg = f"Element ID {elementId} is invalid"
        MessageCenter.ShowErrorMessage(msg, msg, False)
    
    return (valid, eh)
