from MSPyBentley import *
#from MSPyBentleyGeom import *
#from MSPyECObjects import *
from MSPyDgnPlatform import *
from MSPyMstnPlatform import *

MS_REPORT_OUTPUT = str('MS_REPORT_OUTPUT')
    
def GetReportFolder ()->(bool, str):
    '''
    Get a folder where a report file may be written.  
    If configuration variable MS_REPORT_OUTPUT is defined, it gets that path.
    Otherwise, it returns a folder in the operating system TEMP directory.
    Returns: tuple (valid, path)    
    '''
    path = WString()    
    
    status = ConfigurationManager.GetVariable(path, MS_REPORT_OUTPUT)
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
    status = ConfigurationManager.GetLocalTempDirectory (path,"")
    if BentleyStatus.eSUCCESS == status:
        return (True, str(path))
        
    return (False, "")

if __name__ == "__main__":  # check if this script is being run directly (not imported as a module)
    
    path = WString()
    valid = False
    (valid, path) = GetReportFolder()
    if valid:
        msg = f"CfgVar Tester report folder {MS_REPORT_OUTPUT}='{path}'"
        MessageCenter.ShowDebugMessage(msg, msg, False)
    else:
        msg = "Unable to get report folder"
        MessageCenter.ShowErrorMessage(msg, msg, False)
    